/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.rendimientos;

import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.persistencia.Exportable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.obj.Comprobante;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.PagoLocalExterior;
import ec.gob.sri.dimm.ats.modelo.obj.rendimientos.DetalleAirRendimiento;
import ec.gob.sri.dimm.ats.modelo.obj.rendimientos.Rendimiento;
import ec.gob.sri.dimm.ats.modelo.util.Constantes;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComprobanteRendimiento
extends Comprobante
implements Exportable {
    private static final long serialVersionUID = -1648064494561816979L;
    public static final String CC_DETALLES_AIR_RENDIMIENTOS = "detallesAirRendimientos";
    private final List<DetalleAirRendimiento> detallesAirRendimientos = new ArrayList<DetalleAirRendimiento>();
    private PagoLocalExterior pagoLocalExterior = new PagoLocalExterior();

    public ComprobanteRendimiento() {
        this.pagoLocalExterior.setPropietario((ObjetoModelo)this);
    }

    public void agregarDetallesAirRendimientos(DetalleAirRendimiento detalleAirRendimiento) {
        detalleAirRendimiento.setPropietario((ObjetoModelo)this);
        this.detallesAirRendimientos.add(detalleAirRendimiento);
        this.firePropertyChange(CC_DETALLES_AIR_RENDIMIENTOS, null, this.detallesAirRendimientos);
    }

    public boolean eliminarDetallesAirRendimientos(DetalleAirRendimiento detalleAirRendimiento) {
        boolean eliminado = this.detallesAirRendimientos.remove((Object)detalleAirRendimiento);
        if (eliminado) {
            this.firePropertyChange(CC_DETALLES_AIR_RENDIMIENTOS, null, this.detallesAirRendimientos);
        }
        return eliminado;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Comprobante)) {
            return false;
        }
        if (this.getPropietario() != null) {
            Rendimiento propietarioObjeto = (Rendimiento)this.getPropietario();
            Comprobante comprobanteAComparar = (Comprobante)((Object)obj);
            Rendimiento propietarioAComparar = (Rendimiento)comprobanteAComparar.getPropietario();
            if (propietarioAComparar != null) {
                return propietarioObjeto.getRetenido().equals((Object)propietarioAComparar.getRetenido()) && super.equals(obj);
            }
        }
        return super.equals(obj);
    }

    @Override
    public ComprobanteRendimiento crearCopiaEdicion() {
        ComprobanteRendimiento copia = new ComprobanteRendimiento();
        copia.setEstablecimiento(super.getEstablecimiento());
        copia.setPuntoEmision(super.getPuntoEmision());
        copia.setSecuencial(super.getSecuencial());
        copia.setNumAutorizacion(super.getNumAutorizacion());
        copia.setFechaEmision(super.getFechaEmision());
        copia.setObligatorio(super.isObligatorio());
        copia.setPagoLocalExterior(this.pagoLocalExterior.crearCopiaEdicion());
        copia.getPagoLocalExterior().setPropietario((ObjetoModelo)copia);
        copia.setPropietario(this.propietario);
        return copia;
    }

    @Override
    public void actualizarInformacion(Comprobante copiaEdicion) {
        ComprobanteRendimiento combrobanteRendimiento = (ComprobanteRendimiento)copiaEdicion;
        this.getPagoLocalExterior().actualizarInformacion(combrobanteRendimiento.getPagoLocalExterior());
        this.setEstablecimiento(copiaEdicion.getEstablecimiento());
        this.setPuntoEmision(copiaEdicion.getPuntoEmision());
        this.setSecuencial(copiaEdicion.getSecuencial());
        this.setNumAutorizacion(copiaEdicion.getNumAutorizacion());
        this.setFechaEmision(copiaEdicion.getFechaEmision());
        this.setObligatorio(copiaEdicion.isObligatorio());
    }

    @Override
    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        if (this.isObligatorio()) {
            if (this.validarPattern("\\d{3}(?<!000)", this.getEstablecimiento(), "El valor Establecimiento debe ser solo n\u00fameros. Diferente de cero. 3 d\u00edgitos. ", resultado).esEstadoFallido()) {
                return resultado;
            }
            if (this.validarPattern("\\d{3}(?<!000)", this.getPuntoEmision(), "El valor Punto de emisi\u00f3n debe ser solo n\u00fameros. Diferente de cero. 3 d\u00edgitos. ", resultado).esEstadoFallido()) {
                return resultado;
            }
            if (this.validarPattern("\\d{1,9}", this.getSecuencial(), "El valor Secuencial debe ser solo n\u00fameros.  M\u00ednimo 1 d\u00edgito, m\u00e1ximo 9. Diferente de cero. ", resultado).esEstadoFallido()) {
                return resultado;
            }
            if (this.validarPattern("\\d{3,49}", this.getNumAutorizacion(), "El valor No. autorizaci\u00f3n debe ser solo n\u00fameros.  M\u00ednimo 3 d\u00edgitos, m\u00e1ximo 49. Diferente de cero. ", resultado).esEstadoFallido()) {
                return resultado;
            }
            if (this.validarSecuencial(resultado).esEstadoFallido()) {
                return resultado;
            }
            if (this.validarNumAutorizacion(resultado).esEstadoFallido()) {
                return resultado;
            }
            if (this.validarFechaEmision(resultado).esEstadoFallido()) {
                return resultado;
            }
        }
        if (!this.validacionExtra(resultado).esEstadoExitoso()) {
            return resultado;
        }
        if (resultado.esEstadoExitoso() && ((Iva)this.getRaizModelo()).periodo.isPeriodoDeAnexoDesdeMarzo2015() && !(resultado = this.getPagoLocalExterior().validar()).esEstadoExitoso()) {
            return resultado;
        }
        return resultado.pasarValidacion();
    }

    @Override
    protected ResultadoValidacion validarFechaEmision(ResultadoValidacion resultado) {
        if (!Util.isFechaMayorIgualPeriodoMesAnio(this.getFechaEmision(), ((Iva)this.getRaizModelo()).getFechaPeriodoDeclarado()) && !((Iva)this.getRaizModelo()).getDatosDeclaracion().isEsMicroEmpresa()) {
            return resultado.fallarValidacion(String.format("La fecha de %s debe ser %s a la fecha del per\u00edodo informado", "emisi\u00f3n", "mayor o igual"));
        }
        return resultado;
    }

    @Override
    public Object importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = elemento.getElementsByTagName("estabRetencion");
        Element eValor = (Element)valorList.item(0);
        this.setEstablecimiento(eValor.getTextContent());
        if (((Iva)this.getRaizModelo()).periodo.isPeriodoDeAnexoDesdeMarzo2015()) {
            this.getPagoLocalExterior().importar(elemento, null);
        }
        valorList = elemento.getElementsByTagName("ptoEmiRetencion");
        eValor = (Element)valorList.item(0);
        this.setPuntoEmision(eValor.getTextContent());
        valorList = elemento.getElementsByTagName("secRetencion");
        eValor = (Element)valorList.item(0);
        this.setSecuencial(eValor.getTextContent());
        valorList = elemento.getElementsByTagName("autRetencion");
        eValor = (Element)valorList.item(0);
        this.setNumAutorizacion(eValor.getTextContent());
        valorList = elemento.getElementsByTagName("fechaEmiRet");
        eValor = (Element)valorList.item(0);
        this.setFechaEmision(Util.importarFecha(eValor));
        NodeList nl = elemento.getElementsByTagName("detalleAirRen");
        int i = 0;
        while (i < nl.getLength()) {
            Node nodo = nl.item(i);
            if (nodo.getNodeType() == 1) {
                Element elem = (Element)nodo;
                DetalleAirRendimiento detalleAirRendimiento = new DetalleAirRendimiento();
                detalleAirRendimiento.setPropietario((ObjetoModelo)this);
                detalleAirRendimiento.importar(elem, null);
                this.agregarDetallesAirRendimientos(detalleAirRendimiento);
            }
            ++i;
        }
        return this;
    }

    public List<DetalleAirRendimiento> getDetallesAirRendimientos() {
        return this.detallesAirRendimientos;
    }

    public String getSerial() {
        return this.getEstablecimiento() + "-" + this.getPuntoEmision() + "-" + this.getSecuencial();
    }

    public Element exportar(Document documento, Element elemento) {
        Element detRet = documento.createElement("detRet");
        Element em = null;
        if (((Iva)this.getRaizModelo()).periodo.isPeriodoDeAnexoDesdeMarzo2015()) {
            em = this.getPagoLocalExterior().exportar(documento, null);
            detRet.appendChild(em);
        }
        em = documento.createElement("estabRetencion");
        em.setTextContent(this.getEstablecimiento());
        detRet.appendChild(em);
        em = documento.createElement("ptoEmiRetencion");
        em.setTextContent(this.getPuntoEmision());
        detRet.appendChild(em);
        em = documento.createElement("secRetencion");
        em.setTextContent(this.getSecuencial());
        detRet.appendChild(em);
        em = documento.createElement("autRetencion");
        em.setTextContent(this.getNumAutorizacion());
        detRet.appendChild(em);
        em = documento.createElement("fechaEmiRet");
        em.setTextContent(Util.dateToStringWithFormat(this.getFechaEmision(), Constantes.FORMATO_FECHA.toPattern()));
        detRet.appendChild(em);
        em = this.obtenerAirRendXml(documento);
        detRet.appendChild(em);
        return detRet;
    }

    private Element obtenerAirRendXml(Document documento) {
        Element airRend = documento.createElement("airRend");
        for (DetalleAirRendimiento dar : this.getDetallesAirRendimientos()) {
            Element elDar = dar.exportarDetalleAirREndimiento(documento);
            airRend.appendChild(elDar);
        }
        return airRend;
    }

    public PagoLocalExterior getPagoLocalExterior() {
        return this.pagoLocalExterior;
    }

    public void setPagoLocalExterior(PagoLocalExterior pagoLocalExterior) {
        this.pagoLocalExterior = pagoLocalExterior;
    }
}

